package nemosofts.notes.app.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

import nemosofts.notes.app.R;
import nemosofts.notes.app.dialog.DialogUtil;
import nemosofts.notes.app.item.Cat;
import nemosofts.notes.app.listeners.ClickListenerPlayList;
import nemosofts.notes.app.utils.helper.DBHelper;


public class AdapterCategories extends RecyclerView.Adapter<AdapterCategories.MyViewHolder> {

    private final DBHelper dbHelper;
    private final Context context;
    private final List<Cat> arrayList;
    private final ClickListenerPlayList clickListenerPlayList;
    private int rowIndex = -1;

    static class MyViewHolder extends RecyclerView.ViewHolder {
        TextView textView;

        MyViewHolder(View view) {
            super(view);
            textView = view.findViewById(R.id.tv_myplaylist);
        }
    }

    public AdapterCategories(Context context, List<Cat> arrayList, ClickListenerPlayList clickListenerPlayList) {
        this.arrayList = arrayList;
        this.context = context;
        this.clickListenerPlayList = clickListenerPlayList;
        dbHelper = new DBHelper(context);
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.row_categories, parent, false);
        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, int position) {
        holder.textView.setText(arrayList.get(position).name());
        holder.textView.setOnClickListener(view -> clickListenerPlayList.onClick(holder.getAbsoluteAdapterPosition()));

        holder.textView.setOnLongClickListener(v -> {
            if (position != 0){
                showDeletNoteDialog(holder.getAbsoluteAdapterPosition());
            }
            return true;
        });

        int intex = Integer.parseInt(arrayList.get(position).id());
        if (rowIndex > -1) {
            if (rowIndex == intex) {
                holder.textView.setBackgroundResource(R.drawable.bg_cat_ok);
            } else {
                holder.textView.setBackgroundResource(R.drawable.bg_cat);
            }
        } else {
            holder.textView.setBackgroundResource(R.drawable.bg_cat);
        }
    }

    private void showDeletNoteDialog(int pos) {
        DialogUtil.trashDialog(context, new DialogUtil.DeleteListener() {
            @Override
            public void onDelete() {
                dbHelper.removePlayList(arrayList.get(pos).id());
                arrayList.remove(pos);
                notifyItemRemoved(pos);
                if (arrayList.isEmpty()) {
                    clickListenerPlayList.onItemZero();
                }
                Toast.makeText(context, "Remove", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onCancel() {
                // this method is empty
            }
        });
    }

    @SuppressLint("NotifyDataSetChanged")
    public void select(int position) {
        rowIndex = position;
        notifyDataSetChanged();
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

}